package app.firezone.synk.network.Activities;

import androidx.annotation.NonNull;
import androidx.appcompat.app.AppCompatActivity;
import androidx.viewpager2.widget.ViewPager2;

import android.annotation.SuppressLint;
import android.os.Bundle;

import com.google.android.material.tabs.TabLayout;
import com.google.android.material.tabs.TabLayoutMediator;
import app.firezone.synk.network.R;
import app.firezone.synk.network.ui.main.SectionsPagerAdapter;

public class RedeemActivity extends AppCompatActivity {




    @SuppressLint("MissingInflatedId")
    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_redeem);



        ViewPager2 viewPager2  = findViewById(R.id.viewPagers);
        viewPager2.setAdapter(new SectionsPagerAdapter(RedeemActivity.this));

        TabLayout tabLayout = findViewById(R.id.tabLayout);
        TabLayoutMediator tabLayoutMediator = new TabLayoutMediator(
                tabLayout, viewPager2, new TabLayoutMediator.TabConfigurationStrategy() {
            @Override
            public void onConfigureTab(@NonNull TabLayout.Tab tab, int position) {
                switch (position){
                    case 0: {
                        tab.setText("UPI");
                        tab.setIcon(R.drawable.baseline_account_balance_wallet_24);
                        break;
                    }
                    case 1: {
                        tab.setText("Bank");
                        tab.setIcon(R.drawable.baseline_account_balance_24);
                        break;
                    }
                    case 2: {
                        tab.setText("Redeem");
                        tab.setIcon(R.drawable.baseline_add_shopping_cart_24);
                        break;
                    }
                }
            }
        }
        );
        tabLayoutMediator.attach();

    }
}